/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui.display;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.ruby.RubySourceEditor;
import com.aptana.editor.ruby.RubySourceViewerConfiguration;
import com.aptana.ruby.debug.core.model.IEvaluationResult;
import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.display.DataDisplay;
import com.aptana.ruby.internal.debug.ui.display.ExecuteHandler;
import com.aptana.ruby.internal.debug.ui.display.IDataDisplay;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;

public class DisplayView
extends ViewPart
implements ITextInputListener,
IPerspectiveListener2 {
    private IDataDisplay fDataDisplay;
    private IDocumentListener fDocumentListener;
    private SourceViewer fSourceViewer;
    private String fRestoredContents;
    private static IMemento fgMemento;

    public void createPartControl(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 66306);
        this.fDataDisplay = new DataDisplay((ITextViewer)this.fSourceViewer);
        this.fSourceViewer.configure((SourceViewerConfiguration)new RubySourceViewerConfiguration(RubySourceEditor.getChainedPreferenceStore(), null));
        IDocument doc = this.getRestoredDocument();
        this.fSourceViewer.setDocument(doc);
        this.fSourceViewer.addTextInputListener((ITextInputListener)this);
        doc.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (event == null) {
                    return;
                }
                String text = event.getText();
                if (text == null) {
                    return;
                }
                String newline = System.getProperty("line.separator");
                if (text.equals(newline)) {
                    IDocument doc = event.getDocument();
                    try {
                        String prefix = doc.get(0, event.getOffset());
                        int index = prefix.lastIndexOf(newline);
                        String line = null;
                        line = index == -1 ? prefix : prefix.substring(index);
                        IRubyStackFrame frame = ExecuteHandler.getEvaluationContext(DisplayView.this.getSite().getWorkbenchWindow());
                        if (frame == null) {
                            return;
                        }
                        if (frame.isSuspended()) {
                            IEvaluationResult result = frame.evaluate(line);
                            if (result == null) {
                                return;
                            }
                            IDataDisplay display = (IDataDisplay)DisplayView.this.getAdapter(IDataDisplay.class);
                            if (display == null) {
                                return;
                            }
                            String toDisplay = ExecuteHandler.valueToCode(result.getValue());
                            display.displayExpressionValue(toDisplay);
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.fRestoredContents = null;
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    protected IDocument getRestoredDocument() {
        Document doc = null;
        doc = this.fRestoredContents != null ? new Document(this.fRestoredContents) : new Document();
        return doc;
    }

    public void setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getControl().setFocus();
        }
    }

    public Object getAdapter(Class required) {
        if (ITextOperationTarget.class.equals((Object)required)) {
            return this.fSourceViewer.getTextOperationTarget();
        }
        if (IFindReplaceTarget.class.equals((Object)required)) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        if (IDataDisplay.class.equals((Object)required)) {
            return this.fDataDisplay;
        }
        if (ITextViewer.class.equals((Object)required)) {
            return this.fSourceViewer;
        }
        return super.getAdapter(required);
    }

    public void saveState(IMemento memento) {
        if (this.fSourceViewer != null) {
            String contents = this.getContents();
            if (contents != null) {
                memento.putTextData(contents);
            }
        } else if (this.fRestoredContents != null) {
            memento.putTextData(this.fRestoredContents);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (fgMemento != null) {
            memento = fgMemento;
        }
        if (memento != null) {
            this.fRestoredContents = memento.getTextData();
        }
    }

    private String getContents() {
        String contents;
        IDocument doc;
        if (this.fSourceViewer != null && (doc = this.fSourceViewer.getDocument()) != null && (contents = doc.get().trim()).length() > 0) {
            return contents;
        }
        return null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        oldInput.removeDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        super.dispose();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        String contents;
        String id;
        if (partRef instanceof IViewReference && changeId.equals("viewHide") && (id = ((IViewReference)partRef).getId()).equals(this.getViewSite().getId()) && (contents = this.getContents()) != null) {
            fgMemento = XMLMemento.createWriteRoot((String)"DisplayViewMemento");
            fgMemento.putTextData(contents);
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

